/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public String getMarkerType() {
        return "org.eclipse.debug.core.breakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        int line;
        block17: {
            block16: {
                ValidBreakpointLocationLocator loc;
                IBreakpoint breakpoint;
                block15: {
                    block14: {
                        if (position.isDeleted()) {
                            return false;
                        }
                        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                        breakpoint = manager.getBreakpoint(marker);
                        if (breakpoint == null) {
                            return false;
                        }
                        if (breakpoint instanceof IJavaStratumLineBreakpoint || breakpoint instanceof IJavaPatternBreakpoint) {
                            return true;
                        }
                        ICompilationUnit cunit = JavaCore.createCompilationUnitFrom((IFile)((IFile)marker.getResource()));
                        if (cunit == null) {
                            return false;
                        }
                        CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)cunit, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_YES, null);
                        if (unit == null) {
                            return false;
                        }
                        loc = new ValidBreakpointLocationLocator(unit, document.getLineOfOffset(position.getOffset()) + 1, true, true);
                        unit.accept((ASTVisitor)loc);
                        if (loc.getLocationType() != 0) break block14;
                        return false;
                    }
                    if (loc.getLocationType() == 3 || !(breakpoint instanceof IJavaWatchpoint)) break block15;
                    return false;
                }
                line = loc.getLineLocation();
                if (MarkerUtilities.getLineNumber((IMarker)marker) != line) break block16;
                if (this.isLineBreakpoint(marker)) {
                    this.ensureRanges(document, marker, line);
                    return this.lineBreakpointExists(marker.getResource(), ((IJavaLineBreakpoint)breakpoint).getTypeName(), line, marker) == null;
                }
                return true;
            }
            if (!(this.isLineBreakpoint(marker) & line == -1)) break block17;
            return false;
        }
        try {
            MarkerUtilities.setLineNumber((IMarker)marker, (int)line);
            if (this.isLineBreakpoint(marker)) {
                this.ensureRanges(document, marker, line);
            }
            return true;
        }
        catch (BadLocationException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return false;
    }

    private void ensureRanges(IDocument document, IMarker marker, int line) throws BadLocationException {
        if (line < 0 || line > document.getNumberOfLines()) {
            return;
        }
        IRegion region = document.getLineInformation(line - 1);
        int charstart = region.getOffset();
        int charend = charstart + region.getLength();
        MarkerUtilities.setCharStart((IMarker)marker, (int)charstart);
        MarkerUtilities.setCharEnd((IMarker)marker, (int)charend);
    }

    private boolean isLineBreakpoint(IMarker marker) {
        return MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.jdt.debug.javaLineBreakpointMarker");
    }

    private IJavaLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber, IMarker currentmarker) throws CoreException {
        String modelId = JDIDebugPlugin.getUniqueIdentifier();
        String markerType = JavaLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            String breakpointTypeName;
            IJavaLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IJavaLineBreakpoint && (marker = (breakpoint = (IJavaLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && marker.getType().equals(markerType) && currentmarker.getId() != marker.getId() && (JavaDebugUtils.typeNamesEqual((String)(breakpointTypeName = breakpoint.getTypeName()), (String)typeName) || breakpointTypeName != null && breakpointTypeName.startsWith(String.valueOf(typeName) + '$')) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }
}

