/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import java.io.File;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.ui.AbstractColumnViewerSupport;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSupport
extends AbstractColumnViewerSupport<TableColumn> {
    private final Table table;

    public TableViewerSupport(TableViewer viewer, File stateFile) {
        super((ColumnViewer)viewer, stateFile);
        this.table = viewer.getTable();
        this.initializeViewerSupport();
    }

    public TableViewerSupport(TableViewer viewer, File stateFile, boolean[] defaultVisibilities) {
        super((ColumnViewer)viewer, stateFile, defaultVisibilities);
        this.table = viewer.getTable();
        this.initializeViewerSupport();
    }

    @Override
    void addColumnSelectionListener(TableColumn column, SelectionListener selectionListener) {
        column.addSelectionListener(selectionListener);
    }

    @Override
    Rectangle getClientArea() {
        return this.table.getClientArea();
    }

    @Override
    TableColumn getColumn(int index) {
        return this.table.getColumn(index);
    }

    @Override
    int getColumnIndexOf(TableColumn column) {
        return this.table.indexOf(column);
    }

    @Override
    AbstractColumnLayout getColumnLayout() {
        if (this.table.getLayout() instanceof AbstractColumnLayout) {
            return (AbstractColumnLayout)this.table.getLayout();
        }
        if (this.table.getParent().getLayout() instanceof AbstractColumnLayout) {
            return (AbstractColumnLayout)this.table.getParent().getLayout();
        }
        return null;
    }

    @Override
    int[] getColumnOrder() {
        return this.table.getColumnOrder();
    }

    TableColumn[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    int getColumnWidth(TableColumn column) {
        return column.getWidth();
    }

    @Override
    int getHeaderHeight() {
        return this.table.getHeaderHeight();
    }

    @Override
    TableColumn getSortColumn() {
        return this.table.getSortColumn();
    }

    @Override
    int getSortDirection() {
        return this.table.getSortDirection();
    }

    @Override
    void setColumnOrder(int[] order) {
        this.table.setColumnOrder(order);
    }

    @Override
    void setColumnResizable(TableColumn column, boolean resizable) {
        column.setResizable(resizable);
    }

    @Override
    void setColumnWidth(TableColumn column, int width) {
        column.setWidth(width);
    }

    @Override
    void setSortColumn(TableColumn column) {
        this.table.setSortColumn(column);
    }

    @Override
    void setSortDirection(int direction) {
        this.table.setSortDirection(direction);
    }
}

